/* eslint-disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

/**
 * The type of the evaluation
 */
export type EvalTypeID = string;
/**
 * Model name. Must be set with a command line argument.
 */
export type ModelName = string;
/**
 * The number of latents for the LLM judge to interpret
 */
export type NumberOfLatents = number;
/**
 * The latents to use (overrides n_latents if supplied)
 */
export type OverrideLatents = number[] | null;
/**
 * Minimum number of required activations
 */
export type DeadLatentThreshold = number;
/**
 * The seed to use for all randomness
 */
export type RandomSeed = number;
/**
 * The name of the dataset to use
 */
export type DatasetName = string;
/**
 * The context size to use for the LLM
 */
export type LLMContextSize = number;
/**
 * LLM batch size. This is set by default in the main script, or it can be set with a command line argument.
 */
export type LLMBatchSize = number;
/**
 * LLM data type. This is set by default in the main script, or it can be set with a command line argument.
 */
export type LLMDataType = string;
/**
 * The size of the buffer to use for scoring
 */
export type BufferSize = number;
/**
 * Whether to allow overlapping sequences for scoring
 */
export type NoOverlap = boolean;
/**
 * The fraction of the maximum activation to use as the activation threshold
 */
export type ActivationThresholdFraction = number;
/**
 * The total number of tokens we'll gather data for
 */
export type TotalTokens = number;
/**
 * Whether to perform the scoring phase, or just return explanation
 */
export type Scoring = boolean;
/**
 * The maximum number of tokens to allow in an explanation
 */
export type MaxTokensInExplanation = number;
/**
 * Whether to use demonstrations in the explanation prompt
 */
export type UseDemosInExplanation = boolean;
/**
 * The number of top activating sequences to use for the generation phase
 */
export type NumberOfTopExamplesForGeneration = number;
/**
 * The number of importance-sampled sequences to use for the generation phase
 */
export type NumberOfIWSampledExamplesForGeneration = number;
/**
 * The number of top sequences to use for scoring
 */
export type NumberOfTopExamplesForScoring = number;
/**
 * The number of random sequences to use for scoring
 */
export type NumberOfRandomExamplesForScoring = number;
/**
 * The number of importance-sampled sequences to use for scoring
 */
export type NumberOfIWSampledExamplesForScoring = number;
/**
 * A unique UUID identifying this specific eval run
 */
export type ID = string;
/**
 * The datetime of the evaluation in epoch milliseconds
 */
export type DateTimeEpochMs = number;
/**
 * AutoInterp detection score, using methodology similar to Eleuther's 'Open Source Automated Interpretability for Sparse Autoencoder Features'
 */
export type AutoInterpScore = number;
/**
 * AutoInterp detection score standard deviation over all tested features
 */
export type AutoInterpStandardDeviation = number;
/**
 * Optional. The details of the evaluation. A list of objects that stores nested or more detailed data, such as details about the absorption of each letter.
 */
export type ResultDetails = BaseResultDetail[];
/**
 * The commit hash of the SAE Bench that ran the evaluation.
 */
export type SAEBenchCommitHash = string;
/**
 * The ID of the SAE in SAE Lens.
 */
export type SAELensID = string | null;
/**
 * The release ID of the SAE in SAE Lens.
 */
export type SAELensReleaseID = string | null;
/**
 * The version of SAE Lens that ran the evaluation.
 */
export type SAELensVersion = string | null;
/**
 * The configuration of the SAE (custom or from SAE Lens) that ran the evaluation. This should match the SAE Lens config schema.
 */
export type SAEConfigDict = {
  [k: string]: unknown;
} | null;

/**
 * An evaluation of the interpretability of SAE latents. This evaluation is based on Eleuther's 'Open Source Automated Interpretability for Sparse Autoencoder Features'
 */
export interface AutoInterp {
  eval_type_id?: EvalTypeID;
  eval_config: EvalConfigType;
  eval_id: ID;
  datetime_epoch_millis: DateTimeEpochMs;
  eval_result_metrics: ResultMetricsCategorized;
  eval_result_details?: ResultDetails;
  sae_bench_commit_hash: SAEBenchCommitHash;
  sae_lens_id: SAELensID;
  sae_lens_release_id: SAELensReleaseID;
  sae_lens_version: SAELensVersion;
  sae_cfg_dict: SAEConfigDict;
  eval_result_unstructured?: unknown;
  [k: string]: unknown;
}
/**
 * The configuration of the evaluation.
 */
export interface EvalConfigType {
  model_name?: ModelName;
  n_latents?: NumberOfLatents;
  override_latents?: OverrideLatents;
  dead_latent_threshold?: DeadLatentThreshold;
  random_seed?: RandomSeed;
  dataset_name?: DatasetName;
  llm_context_size?: LLMContextSize;
  llm_batch_size?: LLMBatchSize;
  llm_dtype?: LLMDataType;
  buffer?: BufferSize;
  no_overlap?: NoOverlap;
  act_threshold_frac?: ActivationThresholdFraction;
  total_tokens?: TotalTokens;
  scoring?: Scoring;
  max_tokens_in_explanation?: MaxTokensInExplanation;
  use_demos_in_explanation?: UseDemosInExplanation;
  n_top_ex_for_generation?: NumberOfTopExamplesForGeneration;
  n_iw_sampled_ex_for_generation?: NumberOfIWSampledExamplesForGeneration;
  n_top_ex_for_scoring?: NumberOfTopExamplesForScoring;
  n_random_ex_for_scoring?: NumberOfRandomExamplesForScoring;
  n_iw_sampled_ex_for_scoring?: NumberOfIWSampledExamplesForScoring;
  [k: string]: unknown;
}
/**
 * The metrics of the evaluation, organized by category. Define your own categories and the metrics that go inside them.
 */
export interface ResultMetricsCategorized {
  autointerp: AutoInterp1;
  [k: string]: unknown;
}
/**
 * Metrics related to autointerp
 */
export interface AutoInterp1 {
  autointerp_score: AutoInterpScore;
  autointerp_std_dev: AutoInterpStandardDeviation;
  [k: string]: unknown;
}
export interface BaseResultDetail {
  [k: string]: unknown;
}
